function toggleNewField(containerId) {
  const el = document.getElementById(containerId);
  if (el) el.classList.toggle('hidden');
}

async function quickAdd(action, nameInputId, selectId, csrf) {
  const nameEl = document.getElementById(nameInputId);
  const selectEl = document.getElementById(selectId);
  if (!nameEl || !selectEl) return;

  const name = nameEl.value.trim();
  if (!name) { alert('Please enter a name'); return; }

  const form = new FormData();
  form.append('action', action);
  form.append('name', name);
  form.append('csrf_token', csrf);

  const res = await fetch('ajax.php', { method: 'POST', body: form });
  if (!res.ok) { alert('Request failed'); return; }
  const data = await res.json();
  if (data && data.id && data.name) {
    const opt = document.createElement('option');
    opt.value = data.id;
    opt.textContent = data.name;
    opt.selected = true;
    selectEl.appendChild(opt);
    nameEl.value = '';
    alert('Added: ' + data.name);
  } else {
    alert('Unexpected response');
  }
}

function confirmDelete(msg) {
  return confirm(msg || 'Are you sure?');
}


// ----- Searchable multi-select for Devices -----
(function () {
  function $(sel, root=document){ return root.querySelector(sel); }
  function $all(sel, root=document){ return Array.from(root.querySelectorAll(sel)); }

  function getLabelFromCheckbox(cb){
    // prefer data-label on the checkbox; fallback to parent row's dataset or sibling text
    return (cb.getAttribute('data-label')
            || cb.closest('.msel-item')?.dataset.label
            || cb.nextElementSibling?.textContent
            || '').trim();
  }

  function updateSummary(box){
    const checked = $all('input[type="checkbox"][name="devices[]"]:checked', box);
    const btn = $('.msel-toggle', box);
    const chips = $('.msel-chips', box);
    chips.innerHTML = '';
    checked.slice(0,6).forEach(cb=>{
      const c = document.createElement('span');
      c.className = 'chip';
      c.textContent = getLabelFromCheckbox(cb);
      chips.appendChild(c);
    });
    if(checked.length>6){
      const more = document.createElement('span');
      more.className = 'chip';
      more.textContent = `+${checked.length-6} more`;
      chips.appendChild(more);
    }
    $('.hint', btn).textContent = checked.length ? `${checked.length} selected` : 'Select devices…';
  }

  function filterList(box){
    const q = ($('.msel-search', box).value || '').trim().toLowerCase();
    let visibleCount = 0;
    $all('.msel-item', box).forEach(row=>{
      const txt = row.dataset.label || row.textContent.toLowerCase();
      const show = !q || txt.includes(q);
      row.style.display = show ? '' : 'none';
      if(show) visibleCount++;
    });
    const empty = $('.msel-empty', box);
    if (empty) empty.style.display = visibleCount ? 'none' : '';
  }

  function closeAll(except){
    $all('.msel-panel').forEach(p=>{
      if (p !== except) p.classList.add('hidden');
    });
  }

  window.initDeviceSelector = function(){
    const box = $('.msel');
    if(!box) return;

    const panel = $('.msel-panel', box);
    const toggle = $('.msel-toggle', box);
    const search = $('.msel-search', box);

    // open/close
    toggle.addEventListener('click', (e)=>{
      e.preventDefault();
      const isHidden = panel.classList.contains('hidden');
      closeAll(isHidden ? panel : null);
      panel.classList.toggle('hidden');
      if(!panel.classList.contains('hidden')){
        search.focus();
        filterList(box);
      }
    });

    // outside click
    document.addEventListener('click', (e)=>{
      if(!box.contains(e.target)) panel.classList.add('hidden');
    });

    // search filter
    search.addEventListener('input', ()=>filterList(box));

    // tick changes
    box.addEventListener('change', (e)=>{
      if(e.target.matches('input[type="checkbox"][name="devices[]"]')){
        updateSummary(box);
      }
    });

    // quick add new device inside panel
    const addBtn = $('#msel-add-btn', box);
    const addInput = $('#msel-add-input', box);
    if(addBtn && addInput){
      addBtn.addEventListener('click', async ()=>{
        const name = addInput.value.trim();
        const csrf = addBtn.dataset.csrf;
        if(!name) return alert('Enter device name');
        const form = new FormData();
        form.append('action','add_device');
        form.append('name', name);
        form.append('csrf_token', csrf);
        const res = await fetch('ajax.php', { method:'POST', body:form });
        if(!res.ok) return alert('Add failed');
        const data = await res.json();
        if(data && data.id){
          const row = document.createElement('label');
          row.className = 'msel-item';
          row.dataset.label = name.toLowerCase();
          row.innerHTML =
            `<input type="checkbox" name="devices[]" value="${data.id}" data-label="${name}" checked>
             <span>${name}</span>`;
          $('.msel-list', box).prepend(row);
          addInput.value = '';
          updateSummary(box);
          filterList(box);
        }
      });
    }

    updateSummary(box);
    filterList(box);
  };

  // ensure it runs even if DOMContentLoaded already fired / caching issues
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', ()=> window.initDeviceSelector && window.initDeviceSelector());
  } else {
    window.initDeviceSelector && window.initDeviceSelector();
  }
  window.addEventListener('load', ()=> window.initDeviceSelector && window.initDeviceSelector());
})();
