<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../helpers.php';
include __DIR__.'/header.php';

$counts = [
  'products' => (int)$pdo->query("SELECT COUNT(*) FROM products")->fetchColumn(),
  'categories' => (int)$pdo->query("SELECT COUNT(*) FROM categories")->fetchColumn(),
  'devices' => (int)$pdo->query("SELECT COUNT(*) FROM devices")->fetchColumn(),
];
?>
<div class="grid-3">
  <div class="stat">
    <div class="value"><?= e($counts['products']) ?></div>
    <div class="label">Products</div>
  </div>
  <div class="stat">
    <div class="value"><?= e($counts['categories']) ?></div>
    <div class="label">Categories</div>
  </div>
  <div class="stat">
    <div class="value"><?= e($counts['devices']) ?></div>
    <div class="label">Devices</div>
  </div>
</div>

<div class="card">
  <h2>Welcome 👋</h2>
  <p>This is the dashboard. Use the sidebar to manage products, categories, and devices.</p>
</div>

<?php include __DIR__.'/footer.php'; ?>
